if((test-path "cards_section*.xml") -and (test-path "json.txt")){
    $BlooBaseFusionMaterials = "Draconian Queen*", "Smog Tank*", "Blight Crusher*", "Blood Pool*", "Sinew Feeder*", "Malgoth*"
    $ImpeBaseFusionMaterials = "Tiamat*", "Aegis*", "Windreaver*", "Absorption Shield*", "Blackrock*", "Nimbus*"
    $RaidBaseFusionMaterials = "Havoc*", "Bulldozer*", "Iron Maiden*", "Missile Silo*", "Demon of Embers*", "Omega*"
    $RighBaseFusionMaterials = "Vigil*", "Contaminant Scour*", "Equalizer*", "Sanctuary*", "Falcion*", "Benediction*"
    $XenoBaseFusionMaterials = "Dreadship*", "Xeno Mothership*", "Daemon*", "Genetics Pit*","Lurker Beast*", "Apex*"
    $VindBaseFusionMaterials = "Vindicator Reactor*"

	$xmlcardslist = @()
	foreach($xml in Get-ChildItem "cards_section*.xml"){
		$xmlcardslist += [xml](Get-Content $xml)
	}
	$carddata = @{}
	foreach($list in $xmlcardslist){
		foreach($card in $list.root.unit){
			$name = $card.name
			$carddata.add([int]$card.id,$name+"-1")
			if(($card.selectnodes("upgrade") | measure).count -gt 0){
				foreach($upg in $card.upgrade){
					$carddata.add([int]$upg.card_id,($name+"-"+$upg.level))
				}
			}
		}
	}
	if(test-path "ownedcards.txt"){remove-item "ownedcards.txt"}
    if(test-path "_ownedcards.txt"){remove-item "_ownedcards.txt"}
    if(test-path "_BlooBaseFusionMaterials.txt"){remove-item "_BlooBaseFusionMaterials.txt"}
    if(test-path "_ImpeBaseFusionMaterials.txt"){remove-item "_ImpeBaseFusionMaterials.txt"}
    if(test-path "_RaidBaseFusionMaterials.txt"){remove-item "_RaidBaseFusionMaterials.txt"}
    if(test-path "_RighBaseFusionMaterials.txt"){remove-item "_RighBaseFusionMaterials.txt"}
    if(test-path "_XenoBaseFusionMaterials.txt"){remove-item "_XenoBaseFusionMaterials.txt"}
    if(test-path "_VindBaseFusionMaterials.txt"){remove-item "_VindBaseFusionMaterials.txt"}
    "//Bloodthirsty base fusion cards" | out-file -encoding "ASCII" -append "_BlooBaseFusionMaterials.txt"
    "//Imperial base fusion cards" | out-file -encoding "ASCII" -append "_ImpeBaseFusionMaterials.txt"
    "//Raider base fusion cards" | out-file -encoding "ASCII" -append "_RaidBaseFusionMaterials.txt"
    "//Righteous base fusion cards" | out-file -encoding "ASCII" -append "_RighBaseFusionMaterials.txt"
    "//Xeno base fusion cards" | out-file -encoding "ASCII" -append "_XenobaseFusionMaterials.txt"
    "//Vindicator Reactors" | out-file -encoding "ASCII" -append "_VindBaseFusionMaterials.txt"
	$x=[String](get-content "json.txt")
	
	#start autoupdate
	$req = $x.IndexOf("request")
	$request = $x.Substring($req + 10,$x.IndexOf("}",$req)-$req-10)
	$requestdata = New-Object psobject
	foreach($line in $request.Split(",")){
		$tmp = $line.Split(""":",[System.StringSplitOptions]::RemoveEmptyEntries)
		$requestdata | Add-Member NoteProperty -Name $tmp[0] -Value $tmp[1]
	}
	$fields=new-object System.Collections.Specialized.NameValueCollection 
	$fields.Add("password",$requestdata.password) 
	$fields.Add("user_id",$requestdata.user_id) 
	$fields.Add("hash",$requestdata.hash) 
	$fields.Add("syncode",$requestdata.syncode) 
	$fields.Add("kong_id",$requestdata.kong_id) 
	$fields.Add("kong_token",$requestdata.kong_token) 
	$fields.Add("kong_name",$requestdata.kong_name) 
	$webclient = new-object System.Net.WebClient 
#	If you are behind proxy, please comment out the following lines and fill with your data!
################################################################################################################################	
#	$proxy = new-object System.Net.WebProxy "myproxy:port"   
#	$webclient.UseDefaultCredentials = $true
#	$proxy.Credentials = $webclient.Credentials
#	$webclient.proxy=$proxy   
################################################################################################################################
	$url = "https://mobile.tyrantonline.com/api.php?message=init&user_id="+$requestdata.user_id
	$r = $webclient.UploadValues($url,$fields)
	$x = (New-Object Text.UTF8Encoding).GetString($r)
	$x | Out-File -encoding "ASCII" "json.txt"
	#autoupdate end
	
	$cards=$x.Substring($x.IndexOf("user_cards")-2,$x.IndexOf("com_sp_mult")-$x.IndexOf("user_cards")).split("{},")
	$index = 2
	while(-not $cards[$index] -eq ""){
		$result = new-object psobject
		$result | Add-Member -Type NoteProperty "id" ([int]($cards[$index].split(""""))[1])
		$result | Add-Member -Type NoteProperty "num_owned" ([int]($cards[$index+1].split(""""))[3])
		$result | Add-Member -Type NoteProperty "num_used" ([int]($cards[$index+2].split(""""))[3])
		if(-not ($cards[$index+3]) -eq ""){
			$result | Add-Member -Type NoteProperty "locked" "True"
			$index+=5
		}else{
			$result | Add-Member -Type NoteProperty "locked" "False"
			$index+=4
		}
		if($result.num_owned -gt 0){
			$line = $carddata.get_item($result.id)
			if($result.num_owned -gt 1){
				$line += " (" + $result.num_owned + ")"
			}
            $line = $line.replace("-6","")
            if ($BlooBaseFusionMaterials | Where-Object {$line -like $_})
            {
                $line | out-file -encoding "ASCII" -append "_BlooBaseFusionMaterials.txt"
            }
            else{
                if ($ImpeBaseFusionMaterials | Where-Object {$line -like $_})
                {
                    $line | out-file -encoding "ASCII" -append "_ImpeBaseFusionMaterials.txt"
                }
                else{
                    if ($RaidBaseFusionMaterials | Where-Object {$line -like $_})
                    {
                        $line | out-file -encoding "ASCII" -append "_RaidBaseFusionMaterials.txt"
                    }
                    else{
                        if ($RighBaseFusionMaterials | Where-Object {$line -like $_})
                        {
                            $line | out-file -encoding "ASCII" -append "_RighBaseFusionMaterials.txt"
                        }
                        else{
                            if ($XenobaseFusionMaterials | Where-Object {$line -like $_})
                            {
                                $line | out-file -encoding "ASCII" -append "_XenobaseFusionMaterials.txt"
                            }
                            else
                            {
                                if ($VindBaseFusionMaterials | Where-Object {$line -like $_})
                                {
                                    $line | out-file -encoding "ASCII" -append "_VindBaseFusionMaterials.txt"
                                }
                                else
                                {
                                    $line | out-file -encoding "ASCII" -append "_ownedcards.txt"
                                }
                            }
                        }
                    }
                }
            }
		}
	}
    " " | out-file -encoding "ASCII" -append "_BlooBaseFusionMaterials.txt"
    " " | out-file -encoding "ASCII" -append "_ImpeBaseFusionMaterials.txt"
    " " | out-file -encoding "ASCII" -append "_RaidBaseFusionMaterials.txt"
    " " | out-file -encoding "ASCII" -append "_RighBaseFusionMaterials.txt"
    " " | out-file -encoding "ASCII" -append "_XenobaseFusionMaterials.txt"
    " " | out-file -encoding "ASCII" -append "_VindBaseFusionMaterials.txt"
    Get-Content _VindBaseFusionMaterials.txt,_BlooBaseFusionMaterials.txt,_ImpeBaseFusionMaterials.txt,_RaidBaseFusionMaterials.txt,_RighBaseFusionMaterials.txt,_XenobaseFusionMaterials.txt,_ownedcards.txt | Set-Content ownedcards.txt
    if(test-path "_ownedcards.txt"){remove-item "_ownedcards.txt"}
    if(test-path "_BlooBaseFusionMaterials.txt"){remove-item "_BlooBaseFusionMaterials.txt"}
    if(test-path "_ImpeBaseFusionMaterials.txt"){remove-item "_ImpeBaseFusionMaterials.txt"}
    if(test-path "_RaidBaseFusionMaterials.txt"){remove-item "_RaidBaseFusionMaterials.txt"}
    if(test-path "_RighBaseFusionMaterials.txt"){remove-item "_RighBaseFusionMaterials.txt"}
    if(test-path "_XenobaseFusionMaterials.txt"){remove-item "_XenobaseFusionMaterials.txt"}
    if(test-path "_VindBaseFusionMaterials.txt"){remove-item "_VindBaseFusionMaterials.txt"}
	
	if(test-path "currentdecks.txt"){remove-item "currentdecks.txt"}
	while(($cards.length - $index) -gt 4){
		$index+=2
		$line = ($cards[$index].split(""""))[1] + ":" + $carddata.get_item([int]($cards[$index+3].split(""""))[3])
		$index+=5
		$deck = ""
		while(-not $cards[$index] -eq ""){
			$deck += "," + $carddata.get_item([int]($cards[$index].split(""""))[1])
			if([int]($cards[$index].split(""""))[3] -gt 1){
				$deck += " #" + $cards[$index].split("""")[3]
			}
			$index++
		}
		$index++
		if(($cards[$index].split(""""))[1] -eq "dominion_id"){
			$line += "," + $carddata.get_item([int]($cards[$index].split(""""))[3])
		}
		$line += $deck
		$line | out-file -encoding "ASCII" -append "currentdecks.txt"
	}

	#if(test-path "ownedcards.txt"){remove-item "ownedcards.txt"}
    "  " | out-file -encoding "ASCII" -append "ownedcards.txt"
    "//cards from restore" | out-file -encoding "ASCII" -append "ownedcards.txt"
	#$x=get-content "json.txt"
	$cards=$x.Substring($x.IndexOf("buyback_data")-2,$x.IndexOf("request")-$x.IndexOf("buyback_data")).split("{},")
	$index = 2
    $temp = $cards[$index]
	while(-not $cards[$index] -eq ""){

		$result = new-object psobject
		$result | Add-Member -Type NoteProperty "card_id" ([int]($cards[$index].split(""""))[1])
		$result | Add-Member -Type NoteProperty "number" ([int]($cards[$index+2].split(""""))[3])
		$result | Add-Member -Type NoteProperty "total_salvaged" ([int]($cards[$index+3].split(""""))[3])
		$result | Add-Member -Type NoteProperty "total_refunded" ([int]($cards[$index+4].split(""""))[3])
		$result | Add-Member -Type NoteProperty "name" ([string]($cards[$index+5].split(""""))[3])
        if (-not $cards[$index+6] -eq "")
        {
            $result | Add-Member -Type NoteProperty "discount_endtime" ([string]($cards[$index+6].split(""""))[3])
        }
        else
        {
            $result | Add-Member -Type NoteProperty "discount_endtime" ([string]("no discount")[3])
        }

		if(-not ($cards[$index+6]) -eq ""){
			$result | Add-Member -Type NoteProperty "locked" "True"
			$index+=8
		}else{
			$result | Add-Member -Type NoteProperty "locked" "False"
			$index+=7
		}

        $result.card_id = $result.card_id;
        $result.number = $result.number;
        $result.total_salvaged = $result.total_salvaged;
        $result.total_refunded = $result.total_refunded;
        $result.name = $result.name;

		if($result.number -gt 0){
			$line = $carddata.get_item($result.card_id)
			if($result.number -gt 1){
				$line += " (" + $result.number + ")"
			}
			$line | out-file -encoding "ASCII" -append "ownedcards.txt"
		}
        $temp = $cards[$index]
	}

}else{"Please run this script in TUO data folder according to instructions!"}